import SwiftUI
import Inject

class WidgetRegistry: ObservableObject {
    var widgets: [any WidgetFactory] = []

    init() {
        registerWidget(TimerWidget(), configuration: .init())
    }

    func registerWidget<WidgetType, Configuration>(_ widget: WidgetType, configuration: Configuration) where WidgetType: Widget, WidgetType.Configuration == Configuration {
        widgets.append(AnyWidget(widget, configuration: configuration))
    }

    func registerWidget<WidgetType>(_ widget: WidgetType) where WidgetType: Widget, WidgetType.Configuration == Void, WidgetType.Configuration == Void {
        widgets.append(AnyWidget(widget, configuration: ()))
    }
}


struct HomeWidgetView: View {
    @ObserveInjection private var iO
    @StateObject var registry: WidgetRegistry = .init()

    var body: some View {
        List {
            ForEach(registry.widgets, id: \.id) { widget in
                widget.contentView
            }
        }
    }
}
