import SwiftUI

struct TextWidget: Widget {
    struct Data: WidgetData {
        var text: String
        var highlight: Bool = false
    }

    func make() -> some View {
        Text(data.text)
            .foregroundColor(data.highlight ? .red : .primary)
    }

    var data: Data
}
